/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.treevisualizer;

import java.util.Vector;
import weka.gui.treevisualizer.Edge;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;

public class PlaceNode2
implements NodePlace {
    private double m_yRatio;
    private Group[] m_groups;
    private Level[] m_levels;
    private int m_groupNum;
    private int m_levelNum;

    @Override
    public void place(Node r) {
        this.m_groupNum = Node.getGCount(r, 0);
        this.m_groups = new Group[this.m_groupNum];
        int noa = 0;
        while (noa < this.m_groupNum) {
            this.m_groups[noa] = new Group();
            this.m_groups[noa].m_gap = 3.0;
            this.m_groups[noa].m_start = -1;
            ++noa;
        }
        this.groupBuild(r);
        this.m_levelNum = Node.getHeight(r, 0);
        this.m_yRatio = 1.0 / (double)(this.m_levelNum + 1);
        this.m_levels = new Level[this.m_levelNum];
        noa = 0;
        while (noa < this.m_levelNum) {
            this.m_levels[noa] = new Level();
            ++noa;
        }
        r.setTop(this.m_yRatio);
        this.yPlacer();
        r.setCenter(0.0);
        this.xPlacer(0);
        this.untangle2();
        this.scaleByMax();
    }

    private void xPlacer(int start) {
        if (this.m_groupNum > 0) {
            this.m_groups[0].m_p.setCenter(0.0);
            int noa = start;
            while (noa < this.m_groupNum) {
                Edge e;
                int alter = 0;
                double c = this.m_groups[noa].m_gap;
                Node r = this.m_groups[noa].m_p;
                int nob = 0;
                while ((e = r.getChild(nob)) != null) {
                    if (e.getTarget().getParent(0) == e) {
                        e.getTarget().setCenter((double)nob * c);
                    } else {
                        ++alter;
                    }
                    ++nob;
                }
                this.m_groups[noa].m_size = (double)(nob - 1 - alter) * c;
                this.xShift(noa);
                ++noa;
            }
        }
    }

    private void xShift(int n) {
        Edge e;
        double m;
        Node r = this.m_groups[n].m_p;
        double h = this.m_groups[n].m_size / 2.0;
        double c = this.m_groups[n].m_p.getCenter();
        this.m_groups[n].m_left = m = c - h;
        this.m_groups[n].m_right = c + h;
        int noa = 0;
        while ((e = r.getChild(noa)) != null) {
            if (e.getTarget().getParent(0) == e) {
                e.getTarget().adjustCenter(m);
            }
            ++noa;
        }
    }

    private void scaleByMax() {
        double l_x = 5000.0;
        double h_x = -5000.0;
        int noa = 0;
        while (noa < this.m_groupNum) {
            if (l_x > this.m_groups[noa].m_left) {
                l_x = this.m_groups[noa].m_left;
            }
            if (h_x < this.m_groups[noa].m_right) {
                h_x = this.m_groups[noa].m_right;
            }
            ++noa;
        }
        double m_scale = h_x - l_x + 1.0;
        if (this.m_groupNum > 0) {
            Node r = this.m_groups[0].m_p;
            r.setCenter((r.getCenter() - l_x) / m_scale);
            int noa2 = 0;
            while (noa2 < this.m_groupNum) {
                Edge e;
                r = this.m_groups[noa2].m_p;
                int nob = 0;
                while ((e = r.getChild(nob)) != null) {
                    Node s = e.getTarget();
                    if (s.getParent(0) == e) {
                        s.setCenter((s.getCenter() - l_x) / m_scale);
                    }
                    ++nob;
                }
                ++noa2;
            }
        }
    }

    private void scaleByInd() {
        Node r = this.m_groups[0].m_p;
        r.setCenter(0.5);
        int noa = 0;
        while (noa < this.m_levelNum) {
            double l_x = this.m_groups[this.m_levels[noa].m_start].m_left;
            double h_x = this.m_groups[this.m_levels[noa].m_end].m_right;
            double m_scale = h_x - l_x + 1.0;
            int nob = this.m_levels[noa].m_start;
            while (nob <= this.m_levels[noa].m_end) {
                Edge e;
                r = this.m_groups[nob].m_p;
                int noc = 0;
                while ((e = r.getChild(noc)) != null) {
                    Node s = e.getTarget();
                    if (s.getParent(0) == e) {
                        s.setCenter((s.getCenter() - l_x) / m_scale);
                    }
                    ++noc;
                }
                ++nob;
            }
            ++noa;
        }
    }

    private void untangle2() {
        Ease a;
        Node nf = null;
        Node ns = null;
        int l = 0;
        int times = 0;
        int tf = 0;
        int ts = 0;
        while ((a = this.overlap(l)) != null) {
            Edge e;
            ++times;
            int f = a.m_place;
            int s = a.m_place + 1;
            while (f != s) {
                --a.m_lev;
                tf = f;
                ts = s;
                f = this.m_groups[f].m_pg;
                s = this.m_groups[s].m_pg;
            }
            l = a.m_lev;
            int pf = 0;
            int ps = 0;
            Node r = this.m_groups[f].m_p;
            Node mark = this.m_groups[tf].m_p;
            nf = null;
            ns = null;
            int noa = 0;
            while (nf != mark) {
                ++pf;
                nf = r.getChild(noa).getTarget();
                ++noa;
            }
            mark = this.m_groups[ts].m_p;
            noa = pf;
            while (ns != mark) {
                ++ps;
                ns = r.getChild(noa).getTarget();
                ++noa;
            }
            Vector<Double> o_pos = new Vector<Double>(20, 10);
            int noa2 = 0;
            while ((e = r.getChild(noa2)) != null) {
                if (e.getTarget().getParent(0) == e) {
                    Double tem = new Double(e.getTarget().getCenter());
                    o_pos.addElement(tem);
                }
                ++noa2;
            }
            --pf;
            double inc = a.m_amount / (double)ps;
            int noa3 = 0;
            while ((e = r.getChild(noa3)) != null) {
                ns = e.getTarget();
                if (ns.getParent(0) == e) {
                    if (noa3 > pf + ps) {
                        ns.adjustCenter(a.m_amount);
                    } else if (noa3 > pf) {
                        ns.adjustCenter(inc * (double)(noa3 - pf));
                    }
                }
                ++noa3;
            }
            nf = r.getChild(0).getTarget();
            this.m_groups[f].m_size = inc = ns.getCenter() - nf.getCenter();
            this.m_groups[f].m_left = r.getCenter() - inc / 2.0;
            this.m_groups[f].m_right = this.m_groups[f].m_left + inc;
            inc = this.m_groups[f].m_left - nf.getCenter();
            int g_num = 0;
            int noa4 = 0;
            while ((e = r.getChild(noa4)) != null) {
                ns = e.getTarget();
                if (ns.getParent(0) == e) {
                    ns.adjustCenter(inc);
                    double shift = ns.getCenter() - (Double)o_pos.elementAt(noa4);
                    if (ns.getChild(0) != null) {
                        this.moveSubtree(this.m_groups[f].m_start + g_num, shift);
                        ++g_num;
                    }
                }
                ++noa4;
            }
        }
    }

    private void moveSubtree(int n, double o) {
        Edge e;
        Node r = this.m_groups[n].m_p;
        int noa = 0;
        while ((e = r.getChild(noa)) != null) {
            if (e.getTarget().getParent(0) == e) {
                e.getTarget().adjustCenter(o);
            }
            ++noa;
        }
        this.m_groups[n].m_left += o;
        this.m_groups[n].m_right += o;
        if (this.m_groups[n].m_start != -1) {
            noa = this.m_groups[n].m_start;
            while (noa <= this.m_groups[n].m_end) {
                this.moveSubtree(noa, o);
                ++noa;
            }
        }
    }

    private void untangle() {
        Ease a;
        Node nf = null;
        Node ns = null;
        int l = 0;
        int times = 0;
        int tf = 0;
        int ts = 0;
        while ((a = this.overlap(l)) != null) {
            ++times;
            int f = a.m_place;
            int s = a.m_place + 1;
            while (f != s) {
                --a.m_lev;
                tf = f;
                ts = s;
                f = this.m_groups[f].m_pg;
                s = this.m_groups[s].m_pg;
            }
            l = a.m_lev;
            int pf = 0;
            int ps = 0;
            Node r = this.m_groups[f].m_p;
            Node mark = this.m_groups[tf].m_p;
            nf = null;
            ns = null;
            int noa = 0;
            while (nf != mark) {
                ++pf;
                nf = r.getChild(noa).getTarget();
                ++noa;
            }
            mark = this.m_groups[ts].m_p;
            noa = pf;
            while (ns != mark) {
                ++ps;
                ns = r.getChild(noa).getTarget();
                ++noa;
            }
            this.m_groups[f].m_gap = Math.ceil(a.m_amount / (double)ps + this.m_groups[f].m_gap);
            this.xPlacer(f);
        }
    }

    private Ease overlap(int l) {
        Ease a = new Ease();
        int noa = l;
        while (noa < this.m_levelNum) {
            int nob = this.m_levels[noa].m_start;
            while (nob < this.m_levels[noa].m_end) {
                a.m_amount = this.m_groups[nob].m_right - this.m_groups[nob + 1].m_left + 2.0;
                if (a.m_amount >= 0.0) {
                    a.m_amount += 1.0;
                    a.m_lev = noa;
                    a.m_place = nob;
                    return a;
                }
                ++nob;
            }
            ++noa;
        }
        return null;
    }

    private void yPlacer() {
        double changer = this.m_yRatio;
        int lev_place = 0;
        if (this.m_groupNum > 0) {
            this.m_groups[0].m_p.setTop(this.m_yRatio);
            this.m_levels[0].m_start = 0;
            int noa = 0;
            while (noa < this.m_groupNum) {
                if (this.m_groups[noa].m_p.getTop() != changer) {
                    this.m_levels[lev_place].m_end = noa - 1;
                    this.m_levels[++lev_place].m_start = noa;
                    changer = this.m_groups[noa].m_p.getTop();
                }
                this.nodeY(this.m_groups[noa].m_p);
                ++noa;
            }
            this.m_levels[lev_place].m_end = this.m_groupNum - 1;
        }
    }

    private void nodeY(Node r) {
        Edge e;
        double h = r.getTop() + this.m_yRatio;
        int noa = 0;
        while ((e = r.getChild(noa)) != null) {
            if (e.getTarget().getParent(0) == e) {
                e.getTarget().setTop(h);
                e.getTarget().getVisible();
            }
            ++noa;
        }
    }

    private void groupBuild(Node r) {
        if (this.m_groupNum > 0) {
            this.m_groupNum = 0;
            this.m_groups[0].m_p = r;
            ++this.m_groupNum;
            int noa = 0;
            while (noa < this.m_groupNum) {
                this.groupFind(this.m_groups[noa].m_p, noa);
                ++noa;
            }
        }
    }

    private void groupFind(Node r, int pg) {
        Edge e;
        boolean first = true;
        int noa = 0;
        while ((e = r.getChild(noa)) != null) {
            if (e.getTarget().getParent(0) == e && e.getTarget().getChild(0) != null && e.getTarget().getCVisible()) {
                if (first) {
                    this.m_groups[pg].m_start = this.m_groupNum;
                    first = false;
                }
                this.m_groups[pg].m_end = this.m_groupNum;
                this.m_groups[this.m_groupNum].m_p = e.getTarget();
                this.m_groups[this.m_groupNum].m_pg = pg;
                this.m_groups[this.m_groupNum].m_id = this.m_groupNum;
                ++this.m_groupNum;
            }
            ++noa;
        }
    }

    private class Ease {
        public int m_place;
        public double m_amount;
        public int m_lev;

        private Ease() {
        }
    }

    private class Group {
        public Node m_p;
        public int m_pg;
        public double m_gap;
        public double m_left;
        public double m_right;
        public double m_size;
        public int m_start;
        public int m_end;
        public int m_id;

        private Group() {
        }
    }

    private class Level {
        public int m_start;
        public int m_end;
        public int m_left;
        public int m_right;

        private Level() {
        }
    }
}

